﻿// ---------------------
//   Author:  K.Wacker 
// ---------------------

using UnityEngine;
using System.Collections;

/// <summary>
/// Steuer den Szenenwechsel vom Splash Screen zum hauptmenü
/// </summary>
public class SplashScreenController : MonoBehaviour {

	// Zuständig für den Scenenwechsel
	public MenueStateController menueStateController;

	// Minimale Zeit, in der SPlash Screen gezeigt wird (Nicht abbrechbar)
	public float minShowTime = 1.5f;

	// Zeit, nach der automatisch zum Hauptmenü gewechselt wird
	public float skipTime = 7f;

	// Timer zur Zeitmessung
	private float timer = 0;

	// Update is called once per frame
	void Update () {
		timer += Time.deltaTime;

		// Verhindere Abbruch, falls Splash Screen noch nicht lang genug angeziegt
		if (timer < minShowTime) {
			return;
		}


		// Falls Spieler bestätigt (Enter, Space), Maustaste drückt oder Zeit abgelaufen ist
		if ( (timer > skipTime) ||										// Zeit abgelaufen
		    (Input.GetButton("Submit") && Input.anyKeyDown) || 			// Taste (Tastatur) gedrückt
			Input.GetMouseButton (0) ||Input.GetMouseButton (1)) {		// Maustaste gedrückt

			// Wechsel zum Hauptmenue
			menueStateController.setNextScene("Menue_Main");
		}
	}
}
